/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class FileConverter {
    protected static void printUsage() {
        System.out.println("Usage:\n\n\t/in input_file_name \n\t[/inEncoding encoding] \n\t/out output_file_name \n\t[/outEncoding encoding]\n\nencoding = {UTF-8, UTF-16, UTF-16LE, UTF-16BE,shift-JIS}\nDefault for inEncoding is UTF-16 and for outEncoding is UTF-8.\n\nFor example:\n\tjava -cp pe.jar filenet.vw.toolkit.utils.FileConverter /in filename /inEncoding UTF-16 /out outfilename /outEncoding UTF-8\n\nThis is the rule for specifying encoding:\n\n\tIf input_file_name specified a file that contains byte order mark\n\t(as in the case of saving as Unicode text in WordPad) \n\tthen don't need to specify inEncoding at all.  \n\n\tIf input_file does not have a byte order mark, then\n\tit is necesary to specify the inEncoding to be UTF-16LE \n\tor UTF-16BE.  Otherwise, the assumption is UTF-16BE, i.e\n\tthe unicode text is assumed to be in big-endian format.\n\n\tFot outEncoding, if only UTF-16 is specified then the \n\toutput_file will be encoded with UTF16-BE. Byte order mark \n\twill always be written in the output file for UTF-16XX outEncoding.\n\nByte order mark (BOM):  FFFE for little endian and FEFF for big endian.\n\nFor Wordpad files saved with Unicode text, to convert to UTF-8 just use:\n\tjava -cp pe.jar filenet.vw.toolkit.utils.FileConverter /in filename /out outfilename");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        VWCommandLineArgs c = new VWCommandLineArgs(args);
        if (c.isPresent("h") || c.isPresent("H")) {
            FileConverter.printUsage();
        }
        String inFile = c.getParameter("in");
        String inEncoding = c.getParameter("inEncoding", "UTF-16");
        String outFile = c.getParameter("out");
        String outEncoding = c.getParameter("outEncoding", "UTF-8");
        if (inFile == null || outFile == null) {
            FileConverter.printUsage();
        }
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), inEncoding));
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), outEncoding)));
            int aChar = 0;
            int size = 0;
            if (outEncoding.endsWith("LE")) {
                writer.print('\ufffe');
            } else if (outEncoding.endsWith("BE")) {
                writer.print('\ufeff');
            }
            while ((aChar = reader.read()) != -1) {
                writer.print((char)aChar);
                ++size;
            }
            System.out.println("Finish converting " + inFile + " (" + inEncoding + ")\nto\n" + outFile + " (" + outEncoding + ").\nNumber of characters = " + size);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e1) {}
            }
        }
    }
}

